/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.races.elf.config.ElfConfig;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IBowAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;

public class AbilityChargedShot
extends Ability
implements ITickableAbility,
IBowAbility,
IAttackAbility {
    public static final ElfConfig serverConfig = TrinketsConfig.SERVER.races.elf;
    protected boolean critReady;
    protected boolean hit;
    protected boolean doDamage;
    protected boolean useMP;
    protected boolean doAbility;
    protected boolean pullingBow;
    protected boolean release;
    protected boolean cancel;
    protected boolean doExplosion = false;
    protected int v1;
    protected int v2;
    protected int v3;
    protected int poundage;
    protected int tension;
    protected int resistance = 0;
    protected float chargeMultiplier;
    protected float damageMultiplier;
    protected float pounds;
    protected float f1;
    protected float f2;
    protected float f3 = 0.0f;
    protected int heldDuration = 0;

    public AbilityChargedShot() {
        super("charged_shot");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void tickAbility(EntityLivingBase entity) {
        MagicStats magic;
        float ManaCost;
        block23: {
            block24: {
                block21: {
                    block22: {
                        ManaCost = AbilityChargedShot.serverConfig.CS_Cost;
                        boolean blacklistedBow = false;
                        if (entity.func_184607_cu() != null && !entity.func_184607_cu().func_190926_b()) {
                            try {
                                String[] configList;
                                for (String s : configList = AbilityChargedShot.serverConfig.bowBlacklist) {
                                    ConfigHelper.ConfigObject object = new ConfigHelper.ConfigObject(s);
                                    if (!object.doesItemMatchEntry(entity.func_184607_cu())) continue;
                                    blacklistedBow = true;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        boolean bow = entity.func_184587_cr() && entity.func_184607_cu().func_77973_b() instanceof ItemBow && !blacklistedBow;
                        magic = Capabilities.getMagicStats((Entity)entity);
                        boolean sneaking = entity.func_70093_af();
                        if (magic == null) {
                            return;
                        }
                        if (!sneaking) break block21;
                        if (!bow) break block22;
                        if (!this.pullingBow) {
                            this.cancel();
                            this.heldDuration = AbilityChargedShot.serverConfig.ChargeTime / 10;
                        } else {
                            ++this.heldDuration;
                        }
                        this.doAbility = true;
                        this.pullingBow = true;
                        if (AbilityChargedShot.serverConfig.ChargeTime >= 12) break block23;
                        break block24;
                    }
                    if (this.pullingBow) {
                        magic.syncToManaCostToHud(0.0f);
                        this.cancel();
                        this.pullingBow = false;
                    }
                    return;
                }
                if (this.doAbility || this.pullingBow) {
                    magic.syncToManaCostToHud(0.0f);
                    this.reset();
                }
                return;
            }
            AbilityChargedShot.serverConfig.ChargeTime = 12;
        }
        if (this.heldDuration > AbilityChargedShot.serverConfig.ChargeTime) {
            this.heldDuration = AbilityChargedShot.serverConfig.ChargeTime;
        }
        float mana = magic.getMana();
        float scale = (float)((double)(this.heldDuration * 100 / AbilityChargedShot.serverConfig.ChargeTime) * 0.01);
        float testCost = ManaCost * (scale * 10.0f);
        if (testCost > 0.0f && testCost > mana) {
            scale = mana / testCost;
            this.cancel = true;
        } else {
            this.cancel = false;
        }
        if (scale <= 0.0f || scale > 0.0f && scale <= 0.25f || scale > 0.25f && scale <= 0.41f || scale > 0.41f && scale <= 0.65f || scale > 0.65f && scale <= 1.0f || scale > 1.0f) {
            // empty if block
        }
        if (scale > 0.0f) {
            if (!this.cancel) {
                if (scale < 1.0f) {
                    if (entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
                        entity.field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), SoundEvents.field_193810_ez, SoundCategory.PLAYERS, 0.1f, scale + 0.5f);
                    }
                    this.critReady = false;
                } else if (!this.critReady) {
                    if (entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
                        entity.field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 0.5f);
                    }
                    this.critReady = true;
                }
            }
            float Cost = MathHelper.func_76131_a((float)(ManaCost * (scale * 10.0f)), (float)0.0f, (float)magic.getMana());
            magic.syncToManaCostToHud(Cost);
        }
    }

    @Override
    public void knockArrow(ArrowNockEvent event) {
        if (!event.getWorld().field_72995_K) {
            this.doAbility = false;
            this.release = false;
            this.hit = false;
            this.doDamage = false;
            this.critReady = false;
            this.doExplosion = false;
            this.useMP = false;
        }
    }

    @Override
    public int onItemUseTick(EntityLivingBase entity, ItemStack stack, int duration) {
        return duration;
    }

    @Override
    public void onItemUseStop(EntityLivingBase entity, ItemStack stack, int duration) {
        if (!entity.field_70170_p.field_72995_K && this.doAbility) {
            if (!this.release) {
                float Cost;
                float ManaCost = AbilityChargedShot.serverConfig.CS_Cost;
                MagicStats magic = Capabilities.getMagicStats((Entity)entity);
                float mana = magic.getMana();
                float scale = (float)((double)(this.heldDuration * 100 / AbilityChargedShot.serverConfig.ChargeTime) * 0.01);
                float testCost = ManaCost * (scale * 10.0f);
                if (testCost > 0.0f && testCost > mana) {
                    scale = mana / testCost;
                }
                if (magic.spendMana(Cost = MathHelper.func_76131_a((float)(ManaCost * (scale * 10.0f)), (float)0.0f, (float)magic.getMana()))) {
                    this.damageMultiplier = scale;
                    this.useMP = true;
                } else {
                    this.damageMultiplier = 0.0f;
                    this.cancel();
                }
                magic.syncToManaCostToHud(0.0f);
            }
            this.pullingBow = false;
            this.release = true;
        }
    }

    @Override
    public void looseArrow(ArrowLooseEvent event) {
    }

    @Override
    public void arrowImpact(ProjectileImpactEvent.Arrow event) {
        World world = event.getEntity().func_130014_f_();
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        EntityArrow arrow = event.getArrow();
        if (!world.field_72995_K && rayTraceResult.field_72313_a != RayTraceResult.Type.MISS && this.doAbility) {
            if (rayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.hit = true;
                this.doDamage = true;
            } else if (this.useMP && this.critReady && AbilityChargedShot.serverConfig.explode) {
                world.func_72876_a((Entity)arrow, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, 2.0f, false);
                this.useMP = false;
            }
        }
    }

    @Override
    public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if ((source.field_76373_n.contentEquals("arrow") || source.func_76352_a() && !source.func_82725_o()) && this.damageMultiplier > 0.0f) {
            float baseMultiplier = AbilityChargedShot.serverConfig.baseMultiplier;
            float adjustedValue = dmg * baseMultiplier;
            if (adjustedValue < AbilityChargedShot.serverConfig.minimumDamageMultiplier) {
                adjustedValue = AbilityChargedShot.serverConfig.minimumDamageMultiplier;
            }
            dmg += adjustedValue * this.damageMultiplier;
            try {
                if (this.useMP && this.critReady && AbilityChargedShot.serverConfig.explode) {
                    Entity attacker = source.func_76346_g();
                    NetworkHandler.sendToTracking(new EffectsRenderPacket(attacker, source.func_76364_f().field_70165_t, source.func_76364_f().field_70163_u, source.func_76364_f().field_70161_v, 0.0, 0.0, 0.0, 0, 5, 0.0f, 0.0f), source.func_76364_f());
                    List splash = attacker.field_70170_p.func_72839_b((Entity)target, target.func_174813_aQ().func_186662_g(1.0));
                    DamageSource source1 = DamageSource.func_188403_a((Entity)source.func_76364_f(), (EntityLivingBase)((EntityLivingBase)attacker)).func_76349_b().func_82726_p();
                    for (Entity e : splash) {
                        if (!(e instanceof EntityLivingBase) || e == attacker) continue;
                        e.func_70097_a(source1, dmg * 0.75f);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cancel();
        }
        return dmg;
    }

    private void reset() {
        this.cancel();
        this.pullingBow = false;
    }

    private void cancel() {
        this.doAbility = false;
        this.release = false;
        this.hit = false;
        this.doDamage = false;
        this.critReady = false;
        this.doExplosion = false;
        this.useMP = false;
        this.heldDuration = 0;
        this.damageMultiplier = 0.0f;
    }

    @Override
    public void onAbilityRemoved(EntityLivingBase entity) {
        MagicStats magic = Capabilities.getMagicStats((Entity)entity);
        magic.syncToManaCostToHud(0.0f);
    }
}

